VERSION 5.00
Begin VB.Form frmUSB 
   Caption         =   "USB Interface"
   ClientHeight    =   5010
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   7665
   LinkTopic       =   "Form1"
   ScaleHeight     =   5010
   ScaleWidth      =   7665
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton BT_Recv 
      Caption         =   "Receive"
      Height          =   375
      Left            =   6600
      TabIndex        =   32
      Top             =   3720
      Width           =   855
   End
   Begin VB.TextBox rx_txt 
      Height          =   1095
      Left            =   3480
      TabIndex        =   31
      Top             =   3720
      Width           =   2895
   End
   Begin VB.CommandButton BT_Send 
      Caption         =   "Send"
      Height          =   375
      Left            =   6600
      TabIndex        =   30
      Top             =   3120
      Width           =   855
   End
   Begin VB.TextBox tx_txt 
      Height          =   375
      Left            =   3480
      MaxLength       =   16
      TabIndex        =   29
      Text            =   "Text To LCD"
      Top             =   3120
      Width           =   2895
   End
   Begin VB.CommandButton cmdPWW 
      Caption         =   "Sound pulse"
      Height          =   375
      Left            =   3480
      TabIndex        =   21
      Top             =   1800
      Width           =   1215
   End
   Begin VB.TextBox txtPWW 
      Alignment       =   2  'Center
      Height          =   375
      Left            =   4800
      TabIndex        =   20
      Text            =   "0"
      Top             =   1800
      Width           =   615
   End
   Begin VB.CommandButton cmdCiclo 
      Caption         =   "Running"
      Height          =   375
      Left            =   120
      TabIndex        =   15
      Top             =   4440
      Width           =   1455
   End
   Begin VB.CommandButton cmdAnalogicas 
      Caption         =   "Analog Input"
      Height          =   375
      Left            =   6240
      TabIndex        =   14
      Top             =   240
      Width           =   1215
   End
   Begin VB.CommandButton cmdEntradas 
      Caption         =   "Read Button"
      Height          =   375
      Left            =   240
      TabIndex        =   13
      Top             =   2280
      Width           =   1095
   End
   Begin VB.CheckBox chkEntrada 
      Caption         =   "Button 3"
      Height          =   255
      Index           =   3
      Left            =   1680
      TabIndex        =   12
      Top             =   2760
      Width           =   1095
   End
   Begin VB.CheckBox chkEntrada 
      Caption         =   "Button 2"
      Height          =   255
      Index           =   2
      Left            =   1680
      TabIndex        =   11
      Top             =   2520
      Width           =   1095
   End
   Begin VB.CheckBox chkEntrada 
      Caption         =   "Button 1"
      Height          =   255
      Index           =   1
      Left            =   1680
      TabIndex        =   10
      Top             =   2280
      Width           =   1095
   End
   Begin VB.CheckBox chkEntrada 
      Caption         =   "Button 0"
      Height          =   255
      Index           =   0
      Left            =   1680
      TabIndex        =   9
      Top             =   2040
      Width           =   1095
   End
   Begin VB.CheckBox chkLed 
      BackColor       =   &H00C0FFC0&
      Caption         =   "LED 3"
      Height          =   255
      Index           =   3
      Left            =   600
      TabIndex        =   8
      Top             =   1200
      Width           =   855
   End
   Begin VB.CheckBox chkLed 
      BackColor       =   &H008080FF&
      Caption         =   "LED 2"
      Height          =   255
      Index           =   2
      Left            =   600
      TabIndex        =   7
      Top             =   960
      Width           =   855
   End
   Begin VB.CheckBox chkLed 
      BackColor       =   &H00C0FFC0&
      Caption         =   "LED 1"
      Height          =   255
      Index           =   1
      Left            =   600
      TabIndex        =   6
      Top             =   720
      Width           =   855
   End
   Begin VB.CheckBox chkLed 
      BackColor       =   &H008080FF&
      Caption         =   "LED 0"
      Height          =   255
      Index           =   0
      Left            =   600
      TabIndex        =   5
      Top             =   480
      Width           =   855
   End
   Begin VB.CommandButton cmdTerminar 
      Caption         =   "EXIT"
      Height          =   375
      Left            =   1680
      TabIndex        =   4
      Top             =   4440
      Width           =   975
   End
   Begin VB.TextBox txtSumando 
      Alignment       =   2  'Center
      Height          =   375
      Index           =   1
      Left            =   1560
      TabIndex        =   2
      Text            =   "0"
      Top             =   3600
      Width           =   495
   End
   Begin VB.TextBox txtSumando 
      Alignment       =   2  'Center
      Height          =   375
      Index           =   0
      Left            =   1080
      TabIndex        =   1
      Text            =   "0"
      Top             =   3600
      Width           =   495
   End
   Begin VB.CommandButton cmdSuma 
      Caption         =   "Suma"
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Top             =   3600
      Width           =   855
   End
   Begin VB.Frame Frame1 
      Caption         =   "Test input Button"
      Height          =   1335
      Left            =   120
      TabIndex        =   23
      Top             =   1800
      Width           =   2775
   End
   Begin VB.Frame Frame2 
      Caption         =   "Test LED"
      Height          =   1575
      Left            =   240
      TabIndex        =   24
      Top             =   120
      Width           =   1815
   End
   Begin VB.Frame Frame3 
      Caption         =   "Test 16 Character Two Lines LCD : display to Line 2"
      Height          =   2175
      Left            =   3240
      TabIndex        =   33
      Top             =   2760
      Width           =   4335
   End
   Begin VB.Label lblAnalogica 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   375
      Index           =   2
      Left            =   5280
      TabIndex        =   18
      Top             =   840
      Width           =   615
   End
   Begin VB.Label lblAnalogica 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   375
      Index           =   1
      Left            =   5280
      TabIndex        =   17
      Top             =   240
      Width           =   615
   End
   Begin VB.Label lblAnalogica 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   375
      Index           =   3
      Left            =   4080
      TabIndex        =   19
      Top             =   840
      Width           =   615
   End
   Begin VB.Label lblAnalogica 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   375
      Index           =   0
      Left            =   4080
      TabIndex        =   16
      Top             =   240
      Width           =   615
   End
   Begin VB.Shape shpInterna 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   375
      Left            =   3480
      Top             =   2280
      Width           =   615
   End
   Begin VB.Label lblControl 
      BackColor       =   &H00FFFFC0&
      BorderStyle     =   1  'Fixed Single
      Height          =   375
      Left            =   3480
      TabIndex        =   22
      Top             =   2280
      Width           =   2655
   End
   Begin VB.Label lblResultado 
      Alignment       =   2  'Center
      BackColor       =   &H00C0FFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   375
      Left            =   2040
      TabIndex        =   3
      Top             =   3600
      Width           =   495
   End
   Begin VB.Label Label1 
      Caption         =   "CH0"
      Height          =   255
      Left            =   3720
      TabIndex        =   25
      Top             =   360
      Width           =   495
   End
   Begin VB.Label Label2 
      Caption         =   "CH1"
      Height          =   375
      Left            =   4800
      TabIndex        =   26
      Top             =   360
      Width           =   495
   End
   Begin VB.Label Label3 
      Caption         =   "CH2"
      Height          =   375
      Left            =   3720
      TabIndex        =   27
      Top             =   960
      Width           =   615
   End
   Begin VB.Label Label4 
      Caption         =   "CH3"
      Height          =   495
      Left            =   4800
      TabIndex        =   28
      Top             =   960
      Width           =   615
   End
End
Attribute VB_Name = "frmUSB"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (hpvDest As Any, hpvSource As Any, ByVal cbCopy As Long)

'The WideCharToMultiByte function maps a wide-character string to a new character string.
'The function is faster when both lpDefaultChar and lpUsedDefaultChar are NULL.

'CodePage
Private Const CP_ACP = 0 'ANSI
Private Const CP_MACCP = 2 'Mac
Private Const CP_OEMCP = 1 'OEM
Private Const CP_UTF7 = 65000
Private Const CP_UTF8 = 65001

'dwFlags
Private Const WC_NO_BEST_FIT_CHARS = &H400
Private Const WC_COMPOSITECHECK = &H200
Private Const WC_DISCARDNS = &H10
Private Const WC_SEPCHARS = &H20 'Default
Private Const WC_DEFAULTCHAR = &H40

Private Declare Function WideCharToMultiByte Lib "kernel32" (ByVal CodePage As Long, _
                                                    ByVal dwFlags As Long, _
                                                    ByVal lpWideCharStr As Long, _
                                                    ByVal cchWideChar As Long, _
                                                    ByVal lpMultiByteStr As Long, _
                                                    ByVal cbMultiByte As Long, _
                                                    ByVal lpDefaultChar As Long, _
                                                    ByVal lpUsedDefaultChar As Long) As Long


Private Function ByteArrayToString(Bytes() As Byte) As String
    Dim iUnicode As Long, i As Long, j As Long
    
    On Error Resume Next
    i = UBound(Bytes)
    
    If (i < 1) Then
        'ANSI, just convert to unicode and return
        ByteArrayToString = StrConv(Bytes, vbUnicode)
        Exit Function
    End If
    i = i + 1
    
    'Examine the first two bytes
    CopyMemory iUnicode, Bytes(0), 2
    
    If iUnicode = Bytes(0) Then 'Unicode
        'Account for terminating null
        If (i Mod 2) Then i = i - 1
        'Set up a buffer to recieve the string
        ByteArrayToString = String$(i / 2, 0)
        'Copy to string
        CopyMemory ByVal StrPtr(ByteArrayToString), Bytes(0), i
    Else 'ANSI
        ByteArrayToString = StrConv(Bytes, vbUnicode)
    End If
                    
End Function

Private Function StringToByteArray(strInput As String, _
                                Optional bReturnAsUnicode As Boolean = True, _
                                Optional bAddNullTerminator As Boolean = False) As Byte()
    
    Dim lRet As Long
    Dim bytBuffer() As Byte
    Dim lLenB As Long
    
    If bReturnAsUnicode Then
        'Number of bytes
        lLenB = LenB(strInput)
        'Resize buffer, do we want terminating null?
        If bAddNullTerminator Then
            ReDim bytBuffer(lLenB)
        Else
            ReDim bytBuffer(lLenB - 1)
        End If
        'Copy characters from string to byte array
        CopyMemory bytBuffer(0), ByVal StrPtr(strInput), lLenB
    Else
  
        lLenB = Len(strInput)
        If bAddNullTerminator Then
            ReDim bytBuffer(lLenB)
        Else
            ReDim bytBuffer(lLenB - 1)
        End If
        lRet = WideCharToMultiByte(CP_ACP, 0&, ByVal StrPtr(strInput), -1, ByVal VarPtr(bytBuffer(0)), lLenB, 0&, 0&)
    End If
    
    StringToByteArray = bytBuffer
    
End Function

Private Sub BT_Send_Click()

    Dim LCD_Buf(17) As Byte
    Dim bAnsi() As Byte
    Dim bUni() As Byte
    Dim str As String
    Dim i As Long
    Dim DLCD As Byte
    Dim lang As Integer
     
    str = tx_txt.Text
    
    lang = Len(str)
    
If lang > 0 Then
    bAnsi = StringToByteArray(str, False)
       
    For i = 0 To 16
        LCD_Buf(i) = &H20    ' Insert space to LCD buffer
    Next i
         
    For i = LBound(bAnsi) To UBound(bAnsi)
        DLCD = bAnsi(i)
        LCD_Buf(i + 1) = DLCD
    Next
   
    If (myOutPipe <> INVALID_HANDLE_VALUE) And (myInPipe <> INVALID_HANDLE_VALUE) Then
      
       LCD_Buf(0) = 6     ' Mode number 6
        
        If (Send(LCD_Buf, 18, 1000) <> 1) Then
            MsgBox "Communication error "
        End If
    End If
     
End If
     
End Sub


Private Sub chkLed_Click(Index As Integer)
    Dim i As Integer
    For i = 0 To 3
        If chkLed(i).Value = vbChecked Then
            Control_Leds 1, i + 1
        Else
            Control_Leds 2, i + 1
        End If
    Next i
End Sub

Private Sub cmdAnalogicas_Click()
    Dim Send_Buf(0 To 64) As Byte
    Dim Rec_Buf(0 To 64) As Byte
    Dim i As Long
    Dim Tiempo As Long
    
    If (myOutPipe <> INVALID_HANDLE_VALUE) And (myInPipe <> INVALID_HANDLE_VALUE) Then
        Send_Buf(0) = 4
        If (Send_Receive(Send_Buf, 1, Rec_Buf, 4, 1000, 1000) <> 1) Then
            MsgBox "Fallo en la lectura analgica"
        Else
            For i = 0 To 3
                lblAnalogica(i).Caption = Rec_Buf(i)
            Next i
        End If
    End If
End Sub

Private Sub cmdCiclo_Click()
    Do
        DoEvents
        cmdEntradas_Click
        cmdAnalogicas_Click
    Loop
End Sub

Private Sub cmdEntradas_Click()
    Dim Send_Buf(0 To 64) As Byte
    Dim Rec_Buf(0 To 64) As Byte
    Dim i As Long
    
    If (myOutPipe <> INVALID_HANDLE_VALUE) And (myInPipe <> INVALID_HANDLE_VALUE) Then
        Send_Buf(0) = 3
        If (Send_Receive(Send_Buf, 1, Rec_Buf, 4, 1000, 1000) <> 1) Then
            MsgBox "Fallo en la lectura de entradas"
        Else
            For i = 0 To 3
                If Rec_Buf(i) = 0 Then
                    chkEntrada(i).Value = vbChecked
                Else
                    chkEntrada(i).Value = vbUnchecked
                End If
            Next i
        End If
    End If
End Sub

Private Sub cmdPWW_Click()
    Dim Send_Buf(0 To 64) As Byte

    If (myOutPipe <> INVALID_HANDLE_VALUE) And (myInPipe <> INVALID_HANDLE_VALUE) Then
        Send_Buf(0) = 5
        Send_Buf(1) = txtPWW.Text
        shpInterna.Width = txtPWW.Text * lblControl.Width / 255
        If (Send(Send_Buf, 2, 1000) <> 1) Then
            MsgBox "Fallo en el PWW"
        End If
    End If

End Sub

Private Sub cmdSuma_Click()
    Dim Send_Buf(0 To 64) As Byte
    Dim Rec_Buf(0 To 64) As Byte

    If (myOutPipe <> INVALID_HANDLE_VALUE) And (myInPipe <> INVALID_HANDLE_VALUE) Then
        Send_Buf(0) = 0
        Send_Buf(1) = txtSumando(0).Text
        Send_Buf(2) = txtSumando(1).Text
        If (Send_Receive(Send_Buf, 3, Rec_Buf, 4, 1000, 1000) <> 1) Then
            MsgBox "Fallo la Suma"
        Else
            lblResultado.Caption = Rec_Buf(0)
        End If
    End If
End Sub

Private Sub cmdTerminar_Click()
    Unload Me
    End
End Sub

Private Sub ApagaLeds()
    Dim i As Byte
    For i = 1 To 4
        Control_Leds 2, i
    Next i
End Sub

Private Sub Control_Leds(Comando As Byte, Dato As Byte)
    Dim Send_Buf(0 To 64) As Byte

    If (myOutPipe <> INVALID_HANDLE_VALUE) And (myInPipe <> INVALID_HANDLE_VALUE) Then
        Send_Buf(0) = Comando
        Send_Buf(1) = Dato
        If (Send(Send_Buf, 2, 1000) <> 1) Then
            MsgBox "Fallo en el LED"
        End If
    End If

End Sub

Private Sub Form_Load()
    myInPipe = INVALID_HANDLE_VALUE
    myOutPipe = INVALID_HANDLE_VALUE
    OpenMPUSBDevice
    shpInterna.Width = 0
    ApagaLeds
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Dim Send_Buf(0 To 64) As Byte

    If (myOutPipe <> INVALID_HANDLE_VALUE) And (myInPipe <> INVALID_HANDLE_VALUE) Then
        Send_Buf(0) = 5
        Send_Buf(1) = 0
        If (Send(Send_Buf, 2, 1000) <> 1) Then
            MsgBox "Fallo en el PWW"
        End If
    End If
    CloseMPUSBDevice
End Sub

Private Sub lblControl_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim Send_Buf(0 To 64) As Byte
    Dim Valor As Long
    
    Valor = 255 * X / lblControl.Width
    shpInterna.Width = X
    
    If (myOutPipe <> INVALID_HANDLE_VALUE) And (myInPipe <> INVALID_HANDLE_VALUE) Then
        Send_Buf(0) = 5
        Send_Buf(1) = Valor
        txtPWW.Text = Valor
        If (Send(Send_Buf, 2, 1000) <> 1) Then
            MsgBox "Fallo en el PWW"
        End If
    End If
    
End Sub
